import json
import os
from collections import defaultdict
from collections import Counter

def count_results(directory):
    results = defaultdict(list)

    for filename in os.listdir(directory):
        if filename.endswith('_val.json'):
            file_path = os.path.join(directory, filename)
            with open(file_path, 'r', encoding='utf-8') as file:
                data = json.load(file)

                for question_id, entry in data.items():
                    answer = entry["multiple_choice"]
                    results[question_id].append(answer)

    return results

'''
def calculate_variance(answers):
    counts = Counter(answers)
    total = sum(counts.values())

    if total == 0:
        return 0

    frequencies = list(counts.values())
    mean_frequency = sum(frequencies) / len(frequencies)
    variance = sum((freq - mean_frequency) ** 2 for freq in frequencies) / len(frequencies)
    return variance
'''

def write_results_to_file(results, output_file):
    uncertainty_results = []
    for question_id, answers in results.items():
        uncertainty = len(Counter(answers))
        uncertainty_results.append((question_id, uncertainty, answers))

    uncertainty_results.sort(key=lambda x: x[1], reverse=True)

    with open(output_file, 'w', encoding='utf-8') as file:
        for question_id, uncertainty, answers in uncertainty_results:
            file.write(f"Question ID: {question_id}, Uncertainty: {uncertainty:.4f}, Answers: {answers}\n")

# 使用示例
directory_path = '/home/test/yxl/MCoT/aokvqa/results/mistral'
result_counts = count_results(directory_path)

output_file_path = '/home/test/yxl/MCoT/aokvqa/results/mistral/results_summary.txt'
write_results_to_file(result_counts, output_file_path)